/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.BlockNpcDoorInterface;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockScriptedDoor
extends BlockNpcDoorInterface
implements IPermission {
    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileScriptedDoor tile;
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (!world.field_72995_K && iblockstate1.func_177230_c() == this && (tile = (TileScriptedDoor)world.func_175625_s(pos)) != null) {
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileScriptedDoor();
    }

    public float func_176195_g(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return ((TileScriptedDoor)Objects.requireNonNull(world.func_175625_s((BlockPos)pos))).blockHardness;
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, Entity exploder, @Nonnull Explosion explosion) {
        return ((TileScriptedDoor)Objects.requireNonNull(world.func_175625_s((BlockPos)pos))).blockResistance;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.ScriptDoorDataSave;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos pos2) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.func_189540_a(iblockstate1, worldIn, blockpos1, neighborBlock, blockpos1);
            }
        } else {
            BlockPos blockpos2 = pos.func_177984_a();
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else {
                boolean flag;
                TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
                if (!worldIn.field_72995_K && tile != null) {
                    EventHooks.onScriptBlockNeighborChanged(tile, pos2);
                }
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
                if ((flag || neighborBlock.func_176223_P().func_185897_m()) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((IProperty)field_176522_N)) {
                    worldIn.func_180501_a(blockpos2, iblockstate2.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        this.func_176512_a(worldIn, pos, flag);
                    }
                }
                int power = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int p = worldIn.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
                    if (p <= power) continue;
                    power = p;
                }
                if (tile != null) {
                    tile.newPower = power;
                }
            }
        }
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return true;
        }
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem.func_77973_b() == CustomRegisters.wand || currentItem.func_77973_b() == CustomRegisters.scripter || currentItem.func_77973_b() == CustomRegisters.scriptedDoorTool) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptDoor, null, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            return true;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        if (tile != null && EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ)) {
            return false;
        }
        this.func_176512_a(world, blockpos1, ((Boolean)iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b)).equals(false));
        return true;
    }

    public void func_180649_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer playerIn) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        if (tile != null) {
            EventHooks.onScriptBlockClicked(tile, playerIn);
        }
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (player.field_71075_bZ.field_75098_d && iblockstate1.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && iblockstate1.func_177230_c() == this) {
            world.func_175698_g(blockpos1);
        }
    }

    public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        if (tile != null) {
            EventHooks.onScriptBlockCollide(tile, entityIn);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        TileScriptedDoor tile;
        if (!world.field_72995_K && (tile = (TileScriptedDoor)world.func_175625_s(pos)) != null && EventHooks.onScriptBlockHarvest(tile, player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_176512_a(@Nonnull World world, @Nonnull BlockPos pos, boolean open) {
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        if (tile != null && EventHooks.onScriptBlockDoorToggle(tile)) {
            return;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            IBlockState iblockstate1;
            BlockPos blockpos = iblockstate.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
            IBlockState iBlockState = iblockstate1 = pos == blockpos ? iblockstate : world.func_180495_p(blockpos);
            if (iblockstate1.func_177230_c() == this && (Boolean)iblockstate1.func_177229_b((IProperty)field_176519_b) != open) {
                world.func_180501_a(blockpos, iblockstate1.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(open)), 10);
                world.func_175704_b(blockpos, pos);
                if (tile != null) {
                    String sound;
                    String string = sound = open ? tile.openSound : tile.closeSound;
                    if (sound != null && !sound.isEmpty()) {
                        Server.sendRangedData(world, pos, 32, EnumPacketClient.FORCE_PLAY_SOUND, SoundCategory.NEUTRAL.ordinal(), sound, Float.valueOf(pos.func_177958_n()), Float.valueOf(pos.func_177956_o()), Float.valueOf(pos.func_177952_p()), Float.valueOf(1.0f), Float.valueOf(1.0f));
                    } else {
                        world.func_180498_a(null, open ? (this.field_149764_J == Material.field_151573_f ? 1005 : 1006) : (this.field_149764_J == Material.field_151573_f ? 1011 : 1012), pos, 0);
                    }
                }
            }
        }
    }
}

